/*
Half-Life MAP viewing utility.
Copyright (C) 2003  Ryan Samuel Gregg

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "stdafx.h"
#include "PTSLoader.h"

CPTSLoader::CPTSLoader(CConfig *Config, CRichTextBox *txtConsole)
{
	this->Config = Config;
	this->txtConsole = txtConsole;
}

bool CPTSLoader::LoadPTSFile(String *sFile, CPointFile **PointFile)
{
	StreamReader *PTSFile;
	String *PTSData;
	String *PTSLines[];
	String *PTSLine[];
	Vertex3f NewVertex;

	txtConsole->Print(String::Concat(S"Loading ", sFile, S"..."), Color::Green);

	try
	{
		PTSFile = File::OpenText(sFile);
	}
	catch(Exception *e)
	{
		txtConsole->Print(String::Concat(S"Error loading ", sFile, S": ", e->Message, S"\n"), Color::Red);
		return false;
	}

	try
	{
		PTSData = PTSFile->ReadToEnd();
	}
	catch(Exception *e)
	{
		txtConsole->Print(String::Concat(S"Error loading ", sFile, S": ", e->Message, S"\n"), Color::Red);
		PTSFile->Close();
		return false;
	}

	PTSFile->Close();

	if(PTSData->EndsWith("\n"))
		PTSData = PTSData->Remove(PTSData->Length - 1, 1);

	PTSLines = PTSData->Split(S"\n"->ToCharArray());

	*PointFile = new CPointFile(Config, PTSLines->Length);

	for(int i = 0; i < PTSLines->Length; i++)
	{
		PTSLine = PTSLines[i]->Split(S" "->ToCharArray());
		
		if(PTSLine->Length < 3)
		{
			txtConsole->Print(String::Concat(S"Error loading ", sFile, S": Too few points on line.\n"), Color::Red);
			return false;
		}

		try
		{
			NewVertex.X = Convert::ToSingle(PTSLine[0]);
			NewVertex.Y = Convert::ToSingle(PTSLine[1]);
			NewVertex.Z = Convert::ToSingle(PTSLine[2]);
			(*PointFile)->SetVertex(i, NewVertex);
		}
		catch(Exception *e)
		{
			txtConsole->Print(String::Concat(S"Error loading ", sFile, S": Cannot convert string to float.\n"), Color::Red);
			return false;
		}
	}

	txtConsole->Print(String::Concat(PTSLines->Length.ToString(), S" points loaded.\n"), Color::Green);

	return true;
}